<html>

<head>
	<title>Redirects</title>
	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
	<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
	<style>
		.mode-off {
			color: #dc3545;
			vertical-align: middle !important;
			font-weight: 900;
		}

		.mode-on {
			vertical-align: middle !important;
			color: #28a745;
			font-weight: 900;
		}

		.wrap-line {
			vertical-align: middle !important;
			word-wrap: break-word;
			max-width: 300px;
		}

		table th,
		table td {
			text-align: center !important;
			vertical-align: middle !important;
		}

		.link {
			padding: 10px 15px;
			background: transparent;
			border: #bccfd8 1px solid;
			border-left: 0px;
			cursor: pointer;
			color: #607d8b
		}

		.disabled {
			cursor: not-allowed;
			color: #bccfd8;
		}

		.current {
			background: #bccfd8;
		}

		.first {
			border-left: #bccfd8 1px solid;
		}

		#pagination {
			margin-top: 20px;
			padding-top: 30px;
			text-align: center;
		}

		#pagination a {
			text-decoration: none;
		}

		.dot {
			padding: 10px 15px;
			background: transparent;
			border-right: #bccfd8 1px solid;
		}

		#overlay {
			background-color: rgba(0, 0, 0, 0.6);
			z-index: 999;
			position: absolute;
			left: 0;
			top: 0;
			width: 100%;
			height: 100%;
			display: none;
		}

		#overlay div {
			position: absolute;
			left: 50%;
			top: 50%;
			margin-top: -32px;
			margin-left: -32px;
		}

		table td.all {
			text-transform: uppercase;
		}
	</style>
	<script>
		function getresult(url) {
			$.ajax({
				url: url,
				type: "GET",
				data: {
					search: $("#search").val(),
					status: $("#status").val(),
					rowcount: $("#rowcount").val()
				},
				beforeSend: function() {
					$("#overlay").show();
				},
				success: function(data) {
					$("#pagination-result").html(data);
					setInterval(function() {
						$("#overlay").hide();
					}, 500);
				},
				error: function() {}
			});
		}

		function changePagination(option) {
			if (option != "") {
				getresult("getresult.php");
			}
		}
		$(function() {
			var frm = $('#searchForm');
			frm.submit(function(e) {
				e.preventDefault();
				$.ajax({
					url: "getresult.php",
					type: "GET",
					data: {
						search: $("#search").val(),
						status: $("#status").val()
					},
					beforeSend: function() {
						$("#overlay").show();
					},
					success: function(data) {
						$("#pagination-result").html(data);
						setInterval(function() {
							$("#overlay").hide();
						}, 500);
					},
					error: function() {}
				});
			});
			$('button.reset').click(function(e) {
				e.preventDefault();
				$("#search").val('');
				$("#rowcount").val('');
				$("#status").val('select');
				getresult("getresult.php");
			});
		});
	</script>
</head>

<body class="bg-light">
	<div id="overlay">
		<div><img src="loading.gif" width="64px" height="64px" /></div>
	</div>
	<div class="container-fluid mt-5">
		<div class="row p-3">
			<div class="col-2">
				<h1>Redirects</h1>
			</div>
			<div class="col-10 float-right">
				<form id="searchForm" method="post">
					<div class="form-inline">
						<div class="form-group col-3">
							<input type="text" class="form-control w-100" name="search" id="search" placeholder="Search...">
						</div>
						<div class="form-group col-3">
							<input type="submit" value="Search" class="btn btn-success w-100">
						</div>

						<div class="form-group col-3">
							<button type="button" class="reset btn btn-secondary w-100">Reset</button>
						</div>
						<div class="form-group col-3">
							<button type="button" id="addRedirect" class="btn btn-primary w-100">Add Redirect</button>
						</div>
					</div>
				</form>
			</div>
		</div>
		<div class="page-content">
			<div id="pagination-result">
				<input type="hidden" id="rowcount" name="rowcount" />
			</div>
		</div>
	</div>
	<!-- boostrap model -->
	<div class="modal fade" id="redirect-model" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="redirectModel"></h4>
				</div>
				<div class="modal-body">
					<form id="redirectInserUpdateForm" name="redirectInserUpdateForm" class="form-horizontal" method="POST">
						<input type="hidden" name="op" id="op">
						<input type="hidden" name="id" id="id">
						<input type="hidden" name="old_domain" id="old_domain">
						<input type="hidden" name="domain_name" id="domain_name">
						<div class="form-row">
							<div class="form-group col-md-6">
								<label for="offerslno">Offer Slno</label>
								<input type="text" class="form-control" name="offerslno" id="offerslno" placeholder="Enter Offer Slno" required>
							</div>
							<div class="form-group col-md-6">
								<label for="offerid">Offer ID</label>
								<input type="text" class="form-control" name="offerid" id="offerid" placeholder="Enter Offer ID" required>
							</div>
							<div class="form-group col-md-6">
								<label for="domain">Domain</label>
								<?php
								require_once('dbcontroller.php');
								$query = "select * from domains order by name";
								$db_handle = new DBController();
								$domains = $db_handle->getRows($query);
								?>
								<?php if ($domains && !empty($domains)) : ?>
									<select id="domain" name="domain" class="form-control">
										<?php foreach ($domains as $domain) : ?>
											<option value="<?php echo $domain['id']; ?>"><?php echo $domain['name']; ?></option>
										<?php endforeach; ?>
									</select>
								<?php endif; ?>
							</div>
							<div class="form-group col-md-6">
								<label class="w-100" for="mode">Mode</label>
								<div class="form-check form-check-inline">
									<input class="form-check-input rmode" type="radio" name="mode" id="onmode" value="on" required>
									<label class="form-check-label" for="onmode"><span class="text-success">On<span></label>
								</div>
								<div class="form-check form-check-inline">
									<input class="form-check-input rmode" type="radio" name="mode" id="offmode" value="off" required>
									<label class="form-check-label" for="offmode"><span class="text-danger">Off<span></label>
								</div>
							</div>
							<div class="form-group col-md-12">
								<label for="link">Link</label>
								<input type="text" pattern="^\/[1]*.\S+1?" class="form-control" id="link" name="link" placeholder="Enter Link eg. /path/to/dir">
							</div>
						</div>
						<div class="form-group">
							<label class="text-success" for="onlink">On Link</label>
							<input type="text" pattern="https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&//=]*)" class="form-control" name="onlink" id="onlink" placeholder="Enter link eg. https://www.domainname.com/path/" required>
						</div>
						<div class="form-group">
							<label class="text-danger" for="offlink">Off Link</label>
							<input type="text" pattern="https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&//=]*)" class="form-control" name="offlink" id="offlink" placeholder="Enter link eg. https://www.domainname.com/path/" required>
						</div>
						<div>
							<button type="submit" class="btn btn-bg btn-primary" id="btn-save">Save</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<!-- end bootstrap model -->
	<!-- start response model -->
	<div class="modal fade" id="respModal" tabindex="-1" role="dialog" aria-labelledby="respModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-xl modal-dialog-scrollable" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-capitalize" id="respModalTitle"></h4>
				</div>
				<div class="modal-body">
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
				</div>
			</div>
		</div>
	</div>
	<!-- end response model -->
	<script>
		$(document).ready(function() {
			$('#domain').change(function() {
				$('#domain_name').val($(this).find(':selected').text());
			});
			$('#addRedirect').click(function() {
				$('#redirectInserUpdateForm').trigger("reset");
				$('#redirectModel').html("Add Redirect");
				$('#op').val('insert');
				$('#old_domain').val('');
				$('#redirect-model').modal('show');
			});
			$('body').on('click', '.edit', function() {
				var id = $(this).data('id');
				$.ajax({
					type: "POST",
					url: "edit.php",
					data: {
						id: id
					},
					dataType: 'json',
					success: function(res) {
						$('#op').val('update');
						$('#redirectModel').html("Edit Redirect");
						$('#redirect-model').modal('show');
						$('#id').val(res.id);
						$('#offerslno').val(res.offerslno);
						$('#offerid').val(res.offerid);
						$('#domain').val(res.did);
						$('#old_domain').val(res.did);
						$('#domain_name').val(res.name);
						$('#link').val(res.link);
						$('#offlink').val(res.offlink);
						$('#onlink').val(res.onlink);
						if (res.mode === "off") {
							$('#offmode').prop('checked', true);
							$('#onmode').prop('checked', false);
						} else {
							$('#offmode').prop('checked', false);
							$('#onmode').prop('checked', true);
						}
					}
				});
			});
			$('body').on('click', '.delete', function() {
				if (confirm("Delete Redirect?") == true) {
					var id = $(this).data('id');
					var did = $(this).data('did');
					var dname = $(this).data('dname');
					$.ajax({
						type: "POST",
						url: "delete.php",
						data: {
							id: id,
							did: did,
							dname: dname
						},
						dataType: 'json',
						success: function(res) {
							// window.location.reload();
							getresult("getresult.php");
							$('#redirectInserUpdateForm').trigger("reset");
							$('#redirect-model').modal('hide');
							$('#respModal').modal('show');
							if (res.status === 'success') {
								$('#respModalTitle').addClass('text-success').html('<p class="m-0">' + res.status + '</p>');
							} else {
								$('#respModalTitle').addClass('text-info').html('<p class="m-0">Info</p>');
							}
							$('#respModal .modal-body').html('<p class="">' + res.message + '</p>');
						}
					});
				}
			});
			$('#redirectInserUpdateForm').submit(function(e) {
				e.preventDefault();
				$.ajax({
					type: "POST",
					url: "insert-update.php",
					data: $(this).serialize(),
					dataType: 'json',
					success: function(res) {
						// window.location.reload();
						getresult("getresult.php");
						$('#redirectInserUpdateForm').trigger("reset");
						$('#redirect-model').modal('hide');
						$('#respModal').modal('show');
						if (res.status === 'success') {
							$('#respModalTitle').addClass('text-success').html('<p class="m-0">' + res.status + '</p>');
						} else {
							$('#respModalTitle').addClass('text-info').html('<p class="m-0">Info</p>');
						}
						$('#respModal .modal-body').html('<p class="">' + res.message + '</p>');
					}
				});
			});
		});
		getresult("getresult.php");
	</script>
</body>

</html>