<?php
class DBController {
  private $host = "localhost";
  private $user = "dailynil_domain_redirects";
  private $password = '$DpaVK-&wUYB';
  private $database = "dailynil_domain_redirects";
  private $targetpath = "/home/dailynil/";
  private $conn;
  function __construct() {
    $this->conn = $this->connectDB();
    $this->targetpath = "/home/dailynil/";
  }
  function connectDB() {
    $conn = mysqli_connect($this->host, $this->user, $this->password, $this->database);
    return $conn;
  }
  function getRows($query) {
    $result = mysqli_query($this->conn, $query);
    while ($row = mysqli_fetch_assoc($result)) {
      $resultset[] = $row;
    }
    if (!empty($resultset)) {
      return $resultset;
    } else {
      return mysqli_error($this->conn);
    }
  }
  function numRows($query) {
    $result  = mysqli_query($this->conn, $query);
    $rowcount = mysqli_num_rows($result);
    return $rowcount;
  }
  function deleteById($id, $domain, $domain_name) {
    $query = "DELETE FROM redirects WHERE id='" . $id . "'";
    $res = mysqli_query($this->conn, $query);
    if ($res) {
      $message = '<p class="text-success">Total ' . $this->conn->affected_rows . ' Redirect row(s) deleted.</p>';
      if ($this->conn->affected_rows > 0) {
        $message .= $this->generateDomainRedirects($domain, $domain_name);
      }
      echo json_encode(["status" => $res, "message" => $message]);
    } else {
      echo json_encode(["status" => false, "message" => "<p class='text-danger'>Error: " . mysqli_error($this->conn) . '</p>']);
    }
  }
  function insertByQuery($query, $domain, $domain_name) {
    $res = mysqli_query($this->conn, $query);
    if ($res && $this->conn->affected_rows > 0) {
      $message = '<p class="text-success">Redirect added.</p>';
      if ($this->conn->affected_rows > 0) {
        $message .= $this->generateDomainRedirects($domain, $domain_name);
      }
    } else {
      $res = false;
      $message = "<p class='text-danger'>Error: " . mysqli_error($this->conn) . '</p>';
    }
    echo json_encode(["status" => $res, "message" => $message]);
  }
  function updateByQuery($query, $domain, $domain_name, $old_domain) {
    $res = mysqli_query($this->conn, $query);
    if ($res) {
      $res = 'success';
      $message = '<p class="text-success">Total ' . $this->conn->affected_rows . ' Redirect row(s) updated.</p>';
      if ($this->conn->affected_rows > 0) {
        if ($old_domain == '1' || $domain == '1') {
          $message .= $this->generateAllDomainRedirects();
        } elseif ($old_domain != $domain) {
          $message .= $this->updateDomainRedirects($domain, $old_domain);
        } else {
          $message .= $this->generateSingleDomainRedirects($domain, $domain_name);
        }
      }
    } else {
      $res = false;
      $message = "<p class='text-danger'>Error: " . mysqli_error($this->conn) . '</p>';
    }
    echo json_encode(["status" => $res, "message" => $message]);
  }
  function updateDomainRedirects($new_domain, $old_domain) {
    $query = "SELECT * FROM domains where id IN ($new_domain,$old_domain)";
    $result = mysqli_query($this->conn, $query);
    $status = '';
    if ($result->num_rows > 0) {
      while ($domain = mysqli_fetch_assoc($result)) {
        $status .= $this->generateSingleDomainRedirects($domain['id'], $domain['name']);
      }
    } else {
      $status = '<p class="text-danger">Domain not found.</p>';
    }
    return $status;
  }
  function generateDomainRedirects($domain, $domain_name) {
    $status = '';
    if ($domain == '1') {
      $status = $this->generateAllDomainRedirects();
    } else {
      $status = $this->generateSingleDomainRedirects($domain, $domain_name);
    }
    return $status;
  }
  function generateAllDomainRedirects() {
    if (!is_dir($this->targetpath)) {
      mkdir($this->targetpath, 0777, true);
    } else {
      $files = glob($this->targetpath . '/*');
      foreach ($files as $file) {
        if (is_file($file)) {
          unlink($file);
        }
      }
    }
    $query = "SELECT * FROM domains WHERE id!='1'";
    $result = mysqli_query($this->conn, $query);
    $status = '';
    if ($result->num_rows > 0) {
      while ($domain = mysqli_fetch_assoc($result)) {
        $status .= $this->generateSingleDomainRedirects($domain['id'], $domain['name']);
      }
    } else {
      $status = '<p class="text-danger">Domain not found.</p>';
    }
    return $status;
  }

  function generateSingleDomainRedirects($domain, $domain_name) {
    if (!is_dir($this->targetpath)) {
      mkdir($this->targetpath, 0777, true);
    }
    $query = "SELECT d.name as domain_name,link,(CASE WHEN (mode = 'off') THEN offlink ELSE onlink END) AS redirectlink FROM redirects r INNER JOIN domains d ON r.did= d.id WHERE r.did='$domain' or r.did='1' GROUP BY r.link";
    $result = mysqli_query($this->conn, $query);
    $text = PHP_EOL;
    $status = '';
    if ($result->num_rows > 0) {
      while ($row = mysqli_fetch_assoc($result)) {
        $link = trim($row['link'], '/');
        $redirect_link = trim($row['redirectlink']);
        $text .= "Redirect 302 /$link $redirect_link" . PHP_EOL;
      }
    }
    try {
      $ht_file_path = "$this->targetpath$domain_name/.htaccess";
      if (file_exists($ht_file_path)) {
        $htaccess = file_get_contents($ht_file_path);
        $needle_start = '#start_custom_redirects';
        $needle_end = '#end_custom_redirects';
        if (str_contains($htaccess, $needle_start) && str_contains($htaccess, $needle_end)) {
          $new_redirects = $this->replace_between($htaccess, $needle_start, $needle_end, $text);
          file_put_contents($ht_file_path, $new_redirects);
          $status = "<p class='text-success'>Redirects added in <b>$ht_file_path</b></p>";
        } else {
          $status = "<p class='text-danger'>Needle not found in <b>$ht_file_path</b></p>";
        }
      } else {
        $status = "<p class='text-danger'>File <b>$ht_file_path</b> not found</p>";
      }
    } catch (\Throwable $th) {
      $status = $th->getMessage();
    }
    return $status;
  }

  function replace_between($str, $needle_start, $needle_end, $replacement) {
    if (str_contains($str, $needle_start) && str_contains($str, $needle_end)) {
      $pos = strpos($str, $needle_start);
      $start = $pos === false ? 0 : $pos + strlen($needle_start);
      $pos = strpos($str, $needle_end, $start);
      $end = $pos === false ? strlen($str) : $pos;
      return substr_replace($str, $replacement, $start, $end - $start);
    } else {
      return $str;
    }
  }
}
